<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\User\Follow;

trait TraitUserFollowGetters
{
    use TraitUserFollowProperties;

    final public function getId(): string
    {
        return $this -> id;
    }

    public function getFollowedUserId(): string
    {
        return $this -> followedUserId;
    }

    public function getFollowedByUserId(): string
    {
        return $this -> followedByUserId;
    }

    public function getMetaIsPending(): string
    {
        return $this -> metaIsPending;
    }

    public function getStampRegistration(): string
    {
        return $this -> stampRegistration;
    }

    public function getStampLastUpdate(): string
    {
        return $this -> stampLastUpdate;
    }
}
